*** Settings ***
Resource            /opt/robot-tests/tests/resources/common.resource
Library             /opt/robot-tests/tests/libraries/bodyRequests.py
Library             XML
Library             String
Resource            /opt/robot-tests/tests/resources/common/basicRequests.robot
Resource            ../../resources/common.resource

Suite Teardown      Reset Testing Environment
Test Setup          Reset Testing Environment


*** Variables ***
${API_INVOKER_NOT_REGISTERED}       not-valid
${SUBSCRIBER_ID_NOT_VALID}          not-valid
${SUBSCRIPTION_ID_NOT_VALID}        not-valid


*** Test Cases ***
Creates a new individual CAPIF Event Subscription
    [Tags]    capif_api_events-1
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

Creates a new individual CAPIF Event Subscription with Invalid SubscriberId
    [Tags]    capif_api_events-2
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${SUBSCRIBER_ID_NOT_VALID}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    404    ProblemDetails
    ...    title=Not Found
    ...    status=404
    ...    detail=Invoker or APF or AEF or AMF Not found
    ...    cause=Subscriber Not Found

Deletes an individual CAPIF Event Subscription
    [Tags]    capif_api_events-3
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription

    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${resp}=    Delete Request Capif
    ...    /capif-events/v1/${subscriber_id}/subscriptions/${subscription_id}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Status Should Be    204    ${resp}

Deletes an individual CAPIF Event Subscription with invalid SubscriberId
    [Tags]    capif_api_events-4
    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription

    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${resp}=    Delete Request Capif
    ...    /capif-events/v1/${SUBSCRIBER_ID_NOT_VALID}/subscriptions/${subscription_id}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    404    ProblemDetails
    ...    title=Not Found
    ...    status=404
    ...    detail=Invoker or APF or AEF or AMF Not found
    ...    cause=Subscriber Not Found

Deletes an individual CAPIF Event Subscription with invalid SubscriptionId
    [Tags]    capif_api_events-5

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${request_body}=    Create Events Subscription
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    201    EventSubscription

    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    ${resp}=    Delete Request Capif
    ...    /capif-events/v1/${subscriber_id}/subscriptions/${SUBSCRIPTION_ID_NOT_VALID}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    401    ProblemDetails
    ...    title=Unauthorized
    ...    detail=User not authorized
    ...    cause=You are not the owner of this resource

Invoker receives Service API Invocation events
    [Tags]    capif_api_events-6    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info}=    Provider Default Registration

    # Publish one api
    Publish Service Api    ${register_user_info}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    ${api_ids}    ${api_names}=    Get Api Ids And Names From Discover Response    ${discover_response}

    # Subscribe to events
    ${events_list}=    Create List    SERVICE_API_INVOCATION_SUCCESS    SERVICE_API_INVOCATION_FAILURE
    ${aef_ids}=    Create List    ${register_user_info['aef_id']}
    ${event_filter}=    Create Capif Event Filter    aefIds=${aef_ids}
    ${event_filters}=    Create List    ${event_filter}

    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ...    eventFilters=${event_filters}
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    # Create Log Entry, emulate success and failure api invocation
    ${results}=    Create List    200    400
    ${request_body}=    Create Log Entry
    ...    ${register_user_info['aef_id']}
    ...    ${register_user_info_invoker['api_invoker_id']}
    ...    ${api_ids}
    ...    ${api_names}
    ...    results=${results}
    ${resp}=    Post Request Capif
    ...    /api-invocation-logs/v1/${register_user_info['aef_id']}/logs
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AEF_PROVIDER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    InvocationLog
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_LOGGING_RESOURCE_REGEX}

    Sleep    3s

    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}
    # Check if message follow EventNotification definition.
    Check Variable    ${notification_events_on_mock_server}    EventNotification

    # Create check Events to ensure all notifications were received
    ${check_events}    ${check_events_length}=    Create Events From InvocationLogs
    ...    ${subscription_id}
    ...    ${request_body}

    # Number of events received must be equal than events expected
    Length Should Be    ${notification_events_on_mock_server}    ${check_events_length}
    # Check if events received are the same than expected
    FOR    ${event}    IN    @{check_events}
        Log    ${event}
        List Should Contain Value    ${notification_events_on_mock_server}    ${event}
    END

Invoker subscribe to Service API Available and Unavailable events
    [Tags]    capif_api_events-7    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration

    # Publish one api
    ${service_api_description_published_1}    ${resource_url_1}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    ${api_ids}    ${api_names}=    Get Api Ids And Names From Discover Response    ${discover_response}

    # Subscribe to events
    ${events_list}=    Create List    SERVICE_API_AVAILABLE    SERVICE_API_UNAVAILABLE
    ${aef_ids}=    Create List    ${register_user_info_provider['aef_id']}
    ${event_filter}=    Create Capif Event Filter    aefIds=${aef_ids}
    ${event_filters}=    Create List    ${event_filter}

    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ...    eventFilters=${event_filters}
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    # Provider publish new API
    ${service_api_description_published_2}    ${resource_url_2}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}
    ...    service_2

    # Provider Remove service_1 published API
    ${resp}=    Delete Request Capif
    ...    ${resource_url_1.path}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${APF_PROVIDER_USERNAME}

    Status Should Be    204    ${resp}

    # Check Results

    Sleep    3s
    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}
    # Check if message follow EventNotification definition.
    Check Variable    ${notification_events_on_mock_server}    EventNotification

    # Create Notification Events expected to be received
    ${api_id_1}=    Fetch From Right    ${resource_url_1.path}    /
    ${notification_event_expected_removed}=    Create Notification Event
    ...    ${subscription_id}
    ...    SERVICE_API_UNAVAILABLE
    ...    apiIds=${api_id_1}
    Check Variable    ${notification_event_expected_removed}    EventNotification
    ${api_id_2}=    Fetch From Right    ${resource_url_2.path}    /
    ${notification_event_expected_created}=    Create Notification Event
    ...    ${subscription_id}
    ...    SERVICE_API_AVAILABLE
    ...    apiIds=${api_id_2}
    Check Variable    ${notification_event_expected_created}    EventNotification

    # Check results
    Length Should Be    ${notification_events_on_mock_server}    2
    List Should Contain Value    ${notification_events_on_mock_server}    ${notification_event_expected_removed}
    List Should Contain Value    ${notification_events_on_mock_server}    ${notification_event_expected_created}


Invoker subscribe to Service API Update
    [Tags]    capif_api_events-8    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration

    # Publish one api
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    ${api_ids}    ${api_names}=    Get Api Ids And Names From Discover Response    ${discover_response}

    # Subscribe to events
    ${events_list}=    Create List    SERVICE_API_UPDATE
    ${aef_ids}=    Create List    ${register_user_info_provider['aef_id']}
    ${event_filter}=    Create Capif Event Filter    aefIds=${aef_ids}
    ${event_filters}=    Create List    ${event_filter}

    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ...    eventFilters=${event_filters}
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_invoker['api_invoker_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    # Update Service API
    ${request_body_modified}=    Create Service Api Description    service_1_modified
    ${resp}=    Put Request Capif
    ...    ${resource_url.path}
    ...    json=${request_body_modified}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${APF_PROVIDER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    ServiceAPIDescription
    ...    apiName=service_1_modified

    # Check Results
    Sleep    3s
    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}
    # Check if message follow EventNotification definition.
    Check Variable    ${notification_events_on_mock_server}    EventNotification

    # Create Notification Events expected to be received
    ${api_id}=    Fetch From Right    ${resource_url.path}    /
    Set To Dictionary    ${request_body_modified}   apiId=${api_id}
    ${notification_event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    SERVICE_API_UPDATE
    ...    serviceAPIDescriptions=${request_body_modified}
    Check Variable    ${notification_event_expected}    EventNotification

    # Check results
    Length Should Be    ${notification_events_on_mock_server}    1
    List Should Contain Value    ${notification_events_on_mock_server}    ${notification_event_expected}

Provider subscribe to API Invoker events
    [Tags]    capif_api_events-9    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration

    # Subscribe to events
    ${events_list}=    Create List    API_INVOKER_ONBOARDED  API_INVOKER_UPDATED  API_INVOKER_OFFBOARDED
    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_provider['amf_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AMF_PROVIDER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Update Invoker onboarded information
    ${new_notification_destination}=    Set Variable
    ...    http://${CAPIF_CALLBACK_IP}:${CAPIF_CALLBACK_PORT}/netapp_new_callback
    Set To Dictionary
    ...    ${request_body}
    ...    notificationDestination=${new_notification_destination}
    ${resp}=    Put Request Capif
    ...    ${url.path}
    ...    ${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Update
    Check Response Variable Type And Values    ${resp}    200    APIInvokerEnrolmentDetails
    ...    notificationDestination=${new_notification_destination}

    # Remove Invoker from CCF
    ${resp}=    Delete Request Capif
    ...    ${url.path}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Call Method    ${CAPIF_USERS}    remove_capif_users_entry    ${url.path}

    # Check Remove
    Should Be Equal As Strings    ${resp.status_code}    204

    # Check Results
    Sleep    3s
    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}
    # Check if message follow EventNotification definition.
    Check Variable    ${notification_events_on_mock_server}    EventNotification

    ## Create events expected
    ${events_expected}=    Create List
    ${api_invoker_id}=   Set Variable    ${register_user_info_invoker['api_invoker_id']}
    # Create Notification Events expected to be received for Onboard event
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    API_INVOKER_ONBOARDED
    ...    apiInvokerIds=${api_invoker_id}
    Append To List    ${events_expected}     ${event_expected}

    # Create Notification Events expected to be received for Updated event
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    API_INVOKER_UPDATED
    ...    apiInvokerIds=${api_invoker_id}
    Append To List    ${events_expected}     ${event_expected}

    # Create Notification Events expected to be received for Offboard event
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    API_INVOKER_OFFBOARDED
    ...    apiInvokerIds=${api_invoker_id}
    Append To List    ${events_expected}     ${event_expected}

    Check Variable    ${events_expected}    EventNotification

    # Check results
    ${events_expected_length}=   Get Length    ${events_expected}
    Length Should Be    ${notification_events_on_mock_server}   ${events_expected_length}
    FOR    ${event_expected}    IN    @{events_expected}
        Log    ${event_expected}
        List Should Contain Value    ${notification_events_on_mock_server}    ${event_expected}
    END

Invoker subscribed to ACL update event
    [Tags]    capif_api_events-10    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration

    # Publish one api
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}

    # Store apiId1
    ${serviceApiId}=    Set Variable    ${service_api_description_published['apiId']}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Subscribe to events
    ${events_list}=    Create List    ACCESS_CONTROL_POLICY_UPDATE
    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_provider['amf_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AMF_PROVIDER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}


    # Test
    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${register_user_info_provider['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${discover_response}    200    DiscoveredAPIs

    # create Security Context
    ${request_service_security_body}=    Create Service Security From Discover Response
    ...    http://${CAPIF_HOSTNAME}:${CAPIF_HTTP_PORT}/test
    ...    ${discover_response}
    ${resp}=    Put Request Capif
    ...    /capif-security/v1/trustedInvokers/${register_user_info_invoker['api_invoker_id']}
    ...    json=${request_service_security_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Service Security
    Check Response Variable Type And Values    ${resp}    201    ServiceSecurity
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_SECURITY_RESOURCE_REGEX}

    ${resp}=    Get Request Capif
    ...    /access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${register_user_info_provider['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AEF_PROVIDER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    AccessControlPolicyList
    # Check returned values
    Should Not Be Empty    ${resp.json()['apiInvokerPolicies']}
    Length Should Be    ${resp.json()['apiInvokerPolicies']}    1
    Should Be Equal As Strings
    ...    ${resp.json()['apiInvokerPolicies'][0]['apiInvokerId']}
    ...    ${register_user_info_invoker['api_invoker_id']}

    ${api_invoker_policies}=  Set Variable  ${resp.json()['apiInvokerPolicies']}

    # Check Results
    Sleep    3s
    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}

    ## Create events expected
    ${acc_ctrl_pol_list}=  Create Dictionary   apiId=${serviceApiId}  apiInvokerPolicies=${api_invoker_policies}
    Check Variable    ${acc_ctrl_pol_list}    AccessControlPolicyListExt

    ${events_expected}=    Create List
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    ACCESS_CONTROL_POLICY_UPDATE
    ...    accCtrlPolList=${acc_ctrl_pol_list}

    Append To List    ${events_expected}     ${event_expected}

    Check Variable    ${events_expected}    EventNotification

    # Check results
    ${events_expected_length}=   Get Length    ${events_expected}
    Length Should Be    ${notification_events_on_mock_server}   ${events_expected_length}
    FOR    ${event_expected}    IN    @{events_expected}
        Log    ${event_expected}
        List Should Contain Value    ${notification_events_on_mock_server}    ${event_expected}
    END

Provider receives an ACL unavailable event when invoker remove Security Context.
    [Tags]    capif_api_events-11    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration

    # Publish one api
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}

    # Store apiId1
    ${serviceApiId}=    Set Variable    ${service_api_description_published['apiId']}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Subscribe to events
    ${events_list}=    Create List    ACCESS_CONTROL_POLICY_UNAVAILABLE
    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_provider['amf_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}


    # Test
    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${register_user_info_provider['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${discover_response}    200    DiscoveredAPIs

    # create Security Context
    ${request_service_security_body}=    Create Service Security From Discover Response
    ...    http://${CAPIF_HOSTNAME}:${CAPIF_HTTP_PORT}/test
    ...    ${discover_response}
    ${resp}=    Put Request Capif
    ...    /capif-security/v1/trustedInvokers/${register_user_info_invoker['api_invoker_id']}
    ...    json=${request_service_security_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Service Security
    Check Response Variable Type And Values    ${resp}    201    ServiceSecurity
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_SECURITY_RESOURCE_REGEX}

    # Remove Security Context by Provider
    ${resp}=    Delete Request Capif
    ...    /capif-security/v1/trustedInvokers/${register_user_info_invoker['api_invoker_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AEF_PROVIDER_USERNAME}

    Status Should Be    204    ${resp}

    # Check Results
    Sleep    3s
    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}

    ## Create events expected
    ${events_expected}=    Create List
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    ACCESS_CONTROL_POLICY_UNAVAILABLE
    Append To List    ${events_expected}     ${event_expected}
    Check Variable    ${events_expected}    EventNotification

    # Check results
    ${events_expected_length}=   Get Length    ${events_expected}
    Length Should Be    ${notification_events_on_mock_server}   ${events_expected_length}
    FOR    ${event_expected}    IN    @{events_expected}
        Log    ${event_expected}
        List Should Contain Value    ${notification_events_on_mock_server}    ${event_expected}
    END

Invoker receives an Invoker Authorization Revoked and ACL unavailable event when Provider revoke Invoker Authorization.
    [Tags]    capif_api_events-12    mockserver

    # Start Mock server
    Check Mock Server
    Clean Mock Server

    # Register APF
    ${register_user_info_provider}=    Provider Default Registration

    # Publish one api
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info_provider}

    # Store apiId1
    ${serviceApiId}=    Set Variable    ${service_api_description_published['apiId']}

    # Register INVOKER
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Subscribe to events
    ${events_list}=    Create List    ACCESS_CONTROL_POLICY_UNAVAILABLE  API_INVOKER_AUTHORIZATION_REVOKED
    ${request_body}=    Create Events Subscription
    ...    events=@{events_list}
    ...    notificationDestination=${MOCK_SERVER_URL}/testing
    ${resp}=    Post Request Capif
    ...    /capif-events/v1/${register_user_info_provider['amf_id']}/subscriptions
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Results
    Check Response Variable Type And Values    ${resp}    201    EventSubscription
    ${subscriber_id}    ${subscription_id}=    Check Event Location Header    ${resp}

    # Test
    ${discover_response}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${register_user_info_provider['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${discover_response}    200    DiscoveredAPIs

    ${api_ids}=    Get Api Ids From Discover Response    ${discover_response}

    # create Security Context
    ${request_service_security_body}=    Create Service Security From Discover Response
    ...    http://${CAPIF_HOSTNAME}:${CAPIF_HTTP_PORT}/test
    ...    ${discover_response}
    ${resp}=    Put Request Capif
    ...    /capif-security/v1/trustedInvokers/${register_user_info_invoker['api_invoker_id']}
    ...    json=${request_service_security_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    # Check Service Security
    Check Response Variable Type And Values    ${resp}    201    ServiceSecurity
    ${resource_url}=    Check Location Header    ${resp}    ${LOCATION_SECURITY_RESOURCE_REGEX}

    # Revoke Security Context by Provider
    ${request_body}=    Create Security Notification Body
    ...    ${register_user_info_invoker['api_invoker_id']}
    ...    ${api_ids}
    ${resp}=    Post Request Capif
    ...    /capif-security/v1/trustedInvokers/${register_user_info_invoker['api_invoker_id']}/delete
    ...    json=${request_body}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${AEF_PROVIDER_USERNAME}

    # Check Results
    Status Should Be    204    ${resp}

    # Check Results
    Sleep    3s
    # Get from Mock server the EventNotification Messages sent to callback setup on event subscription.
    ${resp}=    Get Mock Server Messages
    ${notification_events_on_mock_server}=    Set Variable    ${resp.json()}

    ## Create events expected
    ${events_expected}=    Create List
    ## ACCESS_CONTROL_POLICY_UNAVAILABLE event
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    ACCESS_CONTROL_POLICY_UNAVAILABLE
    Append To List    ${events_expected}     ${event_expected}
    ## API_INVOKER_AUTHORIZATION_REVOKED event
    ${event_expected}=    Create Notification Event
    ...    ${subscription_id}
    ...    API_INVOKER_AUTHORIZATION_REVOKED
    Append To List    ${events_expected}     ${event_expected}
    Check Variable    ${events_expected}    EventNotification

    # Check results
    ${events_expected_length}=   Get Length    ${events_expected}
    Length Should Be    ${notification_events_on_mock_server}   ${events_expected_length}
    FOR    ${event_expected}    IN    @{events_expected}
        Log    ${event_expected}
        List Should Contain Value    ${notification_events_on_mock_server}    ${event_expected}
    END